<?php

namespace App\Controller;

use App\Entity\SqrData;
use App\Form\SqrDataType;
use App\Repository\SqrDataRepository;
use App\Repository\SqrGeneratedKeyRepository;
use App\Repository\SerialRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @Route("/sqr/data")
 */
class SqrDataController extends AbstractController
{
    /**
     * @Route("/", name="app_sqr_data_index", methods={"GET"})
     */
    public function index(SqrDataRepository $sqrDataRepository): Response
    {
        return $this->render('sqr_data/index.html.twig', [
            'sqr_datas' => $sqrDataRepository->findAll(),
        ]);
    }

    /**
     * @Route("/new", name="app_sqr_data_new", methods={"GET", "POST"})
     */
    public function new(Request $request, SqrDataRepository $sqrDataRepository, SqrGeneratedKeyRepository $sqrGeneratedKeyRepository,  SerialRepository $serialRepository): Response
    {
        if ($_POST) 
        {
            $result =  $this->QRGENERATE($_POST);
        } elseif ($_GET) 
        {
            $result =  $this->QRGENERATE($_GET);
        } else 
        {
            $raw = file_get_contents("php://input");
            $jsonData = json_decode($raw, true);
    
            if ($jsonData !== null && !empty($jsonData['cle']) && !empty($jsonData['pieceqr']) && !empty($jsonData['proprietaire'])) 
            {
                $result = $this->QRGENERATE($jsonData, $sqrDataRepository, $sqrGeneratedKeyRepository, $serialRepository);
            }
            else 
            {
                $result = 'Aucune valeur soumise';
            }
        }

        $response = new JsonResponse($result);
        return $response; 
        /*
        $sqrDatum = new SqrData();
        $form = $this->createForm(SqrDataType::class, $sqrDatum);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $sqrDataRepository->add($sqrDatum, true);

            return $this->redirectToRoute('app_sqr_data_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->renderForm('sqr_data/new.html.twig', [
            'sqr_datum' => $sqrDatum,
            'form' => $form,
        ]);*/

    }

    /**
     * @Route("/read", name="app_sqr_data_read", methods={"GET", "POST"})
     */
    public function readAction(Request $request, SqrDataRepository $sqrDataRepository)
    {
        $searchVal = $request->get('v');
        //$repository = $this->get('doctrine_mongodb')
        //->getManager()
        //->getRepository('AMLASQRBundle:SqrData');
        
        $sqrData = $sqrDataRepository->findOneBy(['sqr_code'=>$searchVal]);
        if($sqrData)
        {
            $result = array( 
                'A' => $sqrData->getA(), 
                'B' => $sqrData->getB(), 
                'C' => $sqrData->getC(), 
                'sqr_code'=>$sqrData->getSqrCode(),
                'approot'=>$sqrData->getApproot(),
                'NIU'=>$sqrData->getNIU(),
                'proprietaire'=>$sqrData->getProprietaire(),
                'document'=>$sqrData->getDocument(),
                'donnees'=>$sqrData->lastDonnees(),
                'statut'=>$sqrData->getStatut(),
                'date_creation'=>$sqrData->getDateCreation(),
                'date_modification'=>$sqrData->getDateModification()
            );
                      
        }else
        {
            $result = 'Ce document n\'a aucune référence dans notre système';
        }

        $response = new JsonResponse($result);
        return $response; 
       
    }

    /**
     * @Route("/{id}", name="app_sqr_data_show", methods={"GET"})
     */
    public function show(SqrData $sqrDatum): Response
    {
        return $this->render('sqr_data/show.html.twig', [
            'sqr_datum' => $sqrDatum,
        ]);
    }

    /**
     * @Route("/{id}/edit", name="app_sqr_data_edit", methods={"GET", "POST"})
     */
    public function edit(Request $request, SqrData $sqrDatum, SqrDataRepository $sqrDataRepository): Response
    {
        $form = $this->createForm(SqrDataType::class, $sqrDatum);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $sqrDataRepository->add($sqrDatum, true);

            return $this->redirectToRoute('app_sqr_data_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->renderForm('sqr_data/edit.html.twig', [
            'sqr_datum' => $sqrDatum,
            'form' => $form,
        ]);
    }

    /**
     * @Route("/{id}", name="app_sqr_data_delete", methods={"POST"})
     */
    public function delete(Request $request, SqrData $sqrDatum, SqrDataRepository $sqrDataRepository): Response
    {
        if ($this->isCsrfTokenValid('delete'.$sqrDatum->getId(), $request->request->get('_token'))) {
            $sqrDataRepository->remove($sqrDatum, true);
        }

        return $this->redirectToRoute('app_sqr_data_index', [], Response::HTTP_SEE_OTHER);
    }


    /**
     * Undocumented function.
     *
     * @param [type] $secure
     * @param [type] $approot
     * @param [type] $niu
     * @param [type] $proprietaire
     * @param [type] $document
     * @param [type] $argument
     * @param [type] $statut
     * @param [type] $ladatecreation
     * @param [type] $datemodif
     * @param [type] $apikey
     * @param [type] $idMySQL
     */
    public function InsertDataSQR($secure, $approot, $niu, $proprietaire, $document, $argument, $statut, $ladatecreation, $datemodif, $apikey, $idMySQL)
    {
        $this->__construct();
        $idMySQL = intval($idMySQL);
        $b = $this->genB($idMySQL);
        $c = $this->genC($idMySQL);
        $bulk = new MongoDB\Driver\BulkWrite();
        $data = ['_id' => new MongoDB\BSON\ObjectID(), 'A' => $idMySQL, 'B' => $b, 'C' => $c, 'qr_code' => $secure, 'approot' => $approot, 'NIU' => $niu, 'proprietaire' => $proprietaire, 'document' => $document, 'donnees' => array($argument), 'statut' => $statut, 'date_creation' => $ladatecreation, 'date_modification' => $datemodif];
        $bulk->insert($data);
        if ($this->db->executeBulkWrite('amla_sqr.sqrdata', $bulk)) {
            //echo $secure;
            $arr = array('qr' => $secure, 'pre fix' => $approot, 'niu' => $niu, 'A' => $idMySQL, 'B' => $b, 'C' => $c);
            $donnees = json_encode(array($arr), true);

            echo $donnees;
        } else 
        {
            echo $this->db->error_log('Attention');
        }
    }
    
    /**
     * Générer la famille. (500 numéros de séries)
     *
     * @param [type] $a
     *
     * @return void
     */
    private function genB($a)
    {
        $to = 0;
        if ($a % 500 != 0) {
            $to = 500;
        }

        $b = intval($a / 500) * 500 + $to;

        return $b;
    }

    /**
     * Générer le groupe. (10 familles)
     *
     * @param [type] $a
     *
     * @return void
     */
    private function genC($a)
    {
        $to = 0;
        if ($a % 5000 != 0) {
            $to = 5000;
        }

        $b = intval($a / 5000) * 5000 + $to;

        return $b;
    }

    
    /**
     * Fonction qui retourne le numéro d'identification unique d'un QR après vérification en bd.
     *
     * @param string $newniu
     */
    private function AleaNiu($newniu)
    {
        try {

            $rep = $this->get('doctrine_mongodb')
            ->getManager()
            ->getRepository('AMLASQRBundle:SqrData');
            $reponseNiu = $rep->findBy(['NIU'=>$newniu]);

            if (!empty($reponseNiu)) 
            {
                $newniu = Niu(6, '1234567890');

                return AleaNiu($newniu);
            } else {
                return $newniu;
            }
        } catch (Exception $e) {
            die('Erreur : '.$e->getMessage());
        }
    }

    /**
     * Fonction de calcul du NIU.
     *
     * @param string $longueur
     * @param string $listeCar
     *
     * @return string
     */
    private function Niu($longueur, $listeCar)
    {
        $chaine = '';
        $max = mb_strlen($listeCar, '8bit') - 1;
        $cpt = 0;
        for ($i = 0; $i < $longueur; ++$i) {
            if ($i > 2) {
                if ($i % 4 == 0) {
                    $chaine .= '-';
                }
            }
            $chaine .= $listeCar[random_int(0, $max)];
        }

        return $chaine;
    }

        
    function encrypt(string $data, string $key, string $method): string
    {
        $ivSize = openssl_cipher_iv_length($method);
        $iv = openssl_random_pseudo_bytes($ivSize);
        $encrypted = openssl_encrypt($data, $method, $key, OPENSSL_RAW_DATA, $iv);
        $encrypted = base64_encode($iv.$encrypted);

        return $encrypted;
    }

    function decrypt(string $data, string $key, string $method): string
    {
        $data = base64_decode($data);
        $ivSize = openssl_cipher_iv_length($method);
        $iv = substr($data, 0, $ivSize);
        $data = openssl_decrypt(substr($data, $ivSize), $method, $key, OPENSSL_RAW_DATA, $iv);

        return $data;
    }

    function Salt($longueur, $listeCar)
    {
        $chaine = '';
        $max = mb_strlen($listeCar, '8bit') - 1;
        for ($i = 0; $i < $longueur; ++$i) {
            $chaine .= $listeCar[random_int(0, $max)];
        }

        return $chaine;
    }

    /**
     * Fonction de génération d'un code QR.
     *
     * @param array $argument
     */
    public function QRGENERATE(array $argument, SqrDataRepository $sqrDataRepository, SqrGeneratedKeyRepository $sqrGeneratedKeyRepository,  SerialRepository $serialRepo)
    {//sqrGeneratedKey, serial, sqrData
        $cle = $argument['cle'];
        $pieceqr = $argument['pieceqr'];
        $proprietaire = $argument['proprietaire'];

        try 
        {
            //$rep = $this->get('doctrine_mongodb')
            //->getManager()
            //->getRepository('AMLASQRBundle:SqrGeneratedkey');
            $reponseApiKey = $sqrGeneratedKeyRepository->findOneBy(['appRootKey'=>$cle, 'status'=>0]);

            if(!empty($reponseApiKey))
            {
                //dump($reponseApiKey);die;
                $cleClient = $reponseApiKey->getAppPrefix();
                $approot = $reponseApiKey->getAppRoot();

                //$dm = $this->get('doctrine_mongodb')->getManager();    

                try{
                    $datecreationQR = md5(date('Y-m-d H:i:s'));
                    $ladatecreation = date('Y-m-d H:i:s');

                    $salt = $this->Salt(8, '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ#&$');
                    $secure = bin2hex($salt);
                    $secure = $cleClient.str_replace('+', 'JaDe', $this->encrypt($salt, $cle, METHOD));
                    $statut = 'desactivé';
                    $datemodif = '';
                    $niu = $this->Niu(12, '123456789');
                    
                    //Récupération de l'entité Sérial pour avoir le dernier numéro de série enregistré
                    //$serialRepo = $this->get('doctrine_mongodb')
                    //->getManager()
                    //->getRepository('AMLASQRBundle:Serial');

                    $serial = $serialRepo->findAll();
                    
                    if(empty($serial))
                    {
                        $serial = new Serial();
                        $serial->setLastGenerated(1);
                        
                        $serialRepo->add($serial, false);

                        $numSerie = $serial->getLastGenerated();

                    }else
                    {
                        $serial = $serial[0];
                        $numSerie = $serial->getLastGenerated();
                    }
                    // fin de la récupération
                    
                    $a = $numSerie;
                    $b = $this->genB($a);
                    $c = $this->genC($a);

                    // récupération des objets pour insertion dans bd Mongo
                    $sqrdata = new SqrData();
                    
                    $sqrdata->setA($a);
                    $sqrdata->setB($b);
                    $sqrdata->setC($c);
                    $sqrdata->setQrCode($secure);
                    $sqrdata->setApproot($approot);
                    $sqrdata->setNIU($niu);
                    $sqrdata->setProprietaire($proprietaire);
                    $sqrdata->setDocument($pieceqr);
                    $sqrdata->addDonnees($argument);
                    $sqrdata->setStatut($statut);
                    $sqrdata->setDateCreation($ladatecreation);
                    $sqrdata->setDateModification($datemodif);

                    
                    $sqrDataRepository->add($sqrdata, true);
                                        
                    $arr[] = array('qr' => $secure, 'prefix' => $approot, 'niu' => $niu, 'A' => $a, 'B' => $b, 'C' => $c);
                    
                    // Mise à jour du document nuémro de série
                        $serial->setLastGenerated($serial->getLastGenerated() + 1);
                        
                        $serialRepo->add($serial, true);

                    return $arr;
                    
                } catch (Exception $ex) 
                {
                    die('Erreur :'.$ex->getMessage());
                }

            } else 
            {
                return 'Votre clé API est incorrect';
            }

        } catch (Exception $e) 
        {
            die('Erreur : '.$e->getmessage());
        }
    }

    public function TotooQrScanner($codeqr)
    {
        require 'configmysql.php';
        if ($bdconnect->AmlaSqr()) 
		{
            $req = $bdconnect->bdd->prepare('SELECT * FROM sqr_qr WHERE code_id_qr = :codeqr');
            $req->execute(array('codeqr' => $codeqr));

            $retour = array();

            $ligne = $req->rowCount();
            if ($ligne >= 1) {
                require 'configmongodb.php';

                return $dbc->GetInfosQr($codeqr);
            } else {
                $retour = json_encode(array(array('message' => 'Ce document n\'a aucune référence dans notre système')), JSON_PRETTY_PRINT);

                return $retour;
            }
        }
    }
}
